
/*--------------------------------------------------------------------------*/
/*
   a_star.h
   Creator:			Eric Bengfort
   Date Created:	10.01.2007
   Description:		Header file for A* Path Finding.		Version 5.23	*/
/*--------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
#ifndef A_STAR_H_
#define A_STAR_H_
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <vector>
#include <fstream>
#include <string>
#include <string.h>
#include <assert.h>
#include <math.h>
#include <map>
//---------------------------------------------------------------------------


#define TrueNodeVec ( *GetTrueNodeVecPtr() )  // Looks up the real NodeVec (will the real node vec plz stand up?) And dereferences it.

// Major Note to self:  If an Astar Instance has an external Node Vec Pointer, it is merely where it stores/reads/manips
// its nodeVec.  You can do ANYTHING to it still, nuke it, etc...
// So, need to be smart.  In other words, use with caution; make sure you know what
// you are doing!

// A list of integers.
// Only cares about membership or not.
// Max One copy of an int in each list.  
//    i.e.  the number 5 either appears one or none times.
// This is effectively a wrapper for a STD::MAP, albeit A very simplifed one.
// If we *wanted* to, we could have used a templated class to make a "Smart___List"
// of any type, however, for this project I will always (and only) use Intergers.
class SmartIntList
{
public:
	SmartIntList();
	bool Find(int value);
	void Remove(int value);
	void Add(int value);
	void Clear();
	int Size();
	std::map<int,bool> *GetPtrToMapItself(); // use with care.
private:
	std::map<int,bool> m_Map;

};

struct Node
{
	Node();
	int m_type;
	static const int EMPTY = 0;
	static const int START = 1;
	static const int END = 2;
	static const int WALL = 3;
	float m_F;
	float m_G;
	float m_H;
	int m_Parent;
};



class Astar
{
public:
	Astar(int w, int h, std::vector<Node> *externalNodeVecPtr); // makes an empty map of size w x h if last param is NULL (this is most likely what you want to do!)
	Astar(std::string file, char empty, char start, char end, char wall);
	int GetWidth();
	int GetHeight();
	void SetWall(int i);
	void SetNonWall(int i);
	void SwapWall(int i); // swaps between Wall<->Empty 
	void SetStart(int i);
	void SetEnd(int i);
	bool IsMapValid();
	bool LetsGo(std::vector<int> &solVec, bool useEightWay, bool ignoreWalls);
	void LoadMapFromFile(std::string file, char empty, char start, char end, char wall);
	bool IsInSolVec(const int findIndex, const int startSearchIndex, std::vector<int> solVec);
	std::vector<Node> *GetTrueNodeVecPtr(void);
	void SecureBorders(void); // after loading/making a map, call me to border-ize the perimeter.

	void DebugSendMapToFile(std::string file, char empty, char start, char end, char wall, bool printSol, std::vector<int> &solVec);
	void DebugSendNodesToFile(std::string file);

	int Convert_xy_to_i(int x, int y);
	void Convert_i_to_xy(int i, int &xRet, int &yRet);

	std::vector<int> m_SolVec; // when calling LetsGo, you may use this for a nice place to store results.

	int m_CurSolvVecGoalIndex;

	bool IsWall(const int i); // 11-14-07
	void FindNeighbors(int i, bool useEightWay, bool playerHasSize, std::vector<int> &IntVecRet);

private:
	std::vector<Node> m_NodeVec;  // Private Now.  May NOT exist here.  Use GiveMeNodeVec() marco to access the truth.

	int m_Start;
	int m_End;

	SmartIntList m_OpenList;
	SmartIntList m_ClosedList;
	int m_width;
	int m_height;
	bool IsIndexValid(int i);
	bool DoesExistUp(int i);
	bool DoesExistDown(int i);
	bool DoesExistLeft(int i);
	bool DoesExistRight(int i);
	int OffsetUp(int i);
	int OffsetDown(int i);
	int OffsetLeft(int i);
	int OffsetRight(int i);
	int GetStartIndex();
	int GetEndIndex();
	int GetCurrentSquare();
	void RemoveFromOpenList(int i);
	void RemoveFromClosedList(int i);
	void AddToOpenList(int i, int Parent, int StartIndex, int EndIndex);
	void AddToClosedList(int i);
	void DuplicateList( const std::vector<int> &Original, std::vector<int> &CopyIntVecRet );
	bool IsOnOpenList(int i);
	bool IsOnClosedList(int i);
	void ManhattanH(int i, int j, int &absDeltaX, int &absDeltaY);
	float EuclideanH(int i, int j);
	float CalculateH(int i, int j); // i is where you are, j is end.
	float CalculateG(int i, int j); // i is start, j is where you are.
	float CalculateMovementCost(int i, int j); // i to j.

	std::vector<Node> *m_externalNodeVecPtr;



};

#endif // <---- A_STAR_H_
